/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.helper;

import io.github.fabricators_of_create.porting_lib.event.common.TagsUpdatedCallback;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import slimeknights.mantle.config.Config;
import slimeknights.mantle.util.LogicHelper;
import slimeknights.mantle.util.RegistryHelper;

public class TagPreference {
    private static final class_2960 DEFAULT_ID = new class_2960("zzzzz:zzzzz");
    private static final Map<class_2960, Optional<?>> PREFERENCE_CACHE = new HashMap();
    private static final Map<class_5321<?>, RegistryComparator<?>> COMPARATOR_CACHE = new HashMap();

    public static void init() {
        TagsUpdatedCallback.EVENT.register(e -> PREFERENCE_CACHE.clear());
    }

    private static <T> Comparator<T> getComparator(class_2378<T> registry) {
        return COMPARATOR_CACHE.computeIfAbsent(registry.method_30517(), k -> new RegistryComparator(registry));
    }

    private static <T> Optional<T> getUncachedPreference(class_6862<T> tag) {
        class_2378 registry = RegistryHelper.getRegistry(tag.comp_326());
        if (registry == null) {
            return Optional.empty();
        }
        return RegistryHelper.getTagValueStream(tag).min(TagPreference.getComparator(registry));
    }

    public static <T> Optional<T> getPreference(class_6862<T> tag) {
        return PREFERENCE_CACHE.computeIfAbsent(tag.comp_327(), name -> TagPreference.getUncachedPreference(tag));
    }

    private record RegistryComparator<T>(class_2378<T> registry) implements Comparator<T>
    {
        @Override
        public int compare(T a, T b) {
            int indexB;
            class_2960 idA = Objects.requireNonNullElse(this.registry.method_10221(a), DEFAULT_ID);
            class_2960 idB = Objects.requireNonNullElse(this.registry.method_10221(b), DEFAULT_ID);
            List entries = (List)Config.TAG_PREFERENCES.get();
            int size = entries.size();
            int indexA = LogicHelper.defaultIf(entries.indexOf(idA.method_12836()), -1, size);
            if (indexA != (indexB = LogicHelper.defaultIf(entries.indexOf(idB.method_12836()), -1, size))) {
                return Integer.compare(indexA, indexB);
            }
            return idA.compareNamespaced(idB);
        }
    }
}

